package gov.va.med.mhv.getcare.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PHR_APPOINTMENT")
public class Appointment implements Serializable {

	private static final long serialVersionUID = -30034897458157669L;
	
	@Id
	@Column(name="PHR_APPOINTMENT_ID")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="CURRENT_STATUS")
	private String currentStatus;
	
	@Column(name="CLINIC_NAME")
	private String clinicName;
	
	@Column(name="APPOINTMENT_STATUS")
	private String appointmentStatus;
	
	@Column(name="CLINIC_PHONE")
	private String clinicPhone;
	
	@Column(name="APPOINTMENT_TYPE")
	private String appointmentType;
	
	@Column(name="XRAY_DATE_PRECISE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date xrayDatePrecise;
	
	@Column(name="XRAY_DATE_IMPRECISE")
	private String xrayDateImprecise;
	
	@Column(name="LAB_DATE_PRECISE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date labDatePrecise;
	
	@Column(name="LAB_DATE_IMPRECISE")
	private String labDateImprecise;
	 
	@Column(name="APPT_DATE_PRECISE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date apptDatePrecise;
	
	@Column(name="APPT_DATE_IMPRECISE")
	private String apptDateImprecise;  
	        
	@Column(name="EKG_DATE_PRECISE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date ekgDatePrecise;
	
	@Column(name="EKG_DATE_IMPRECISE")
	private String ekgDateImprecise;         
	      
	@Column(name="IEN")
	private String ien;         
	    
	@Column(name="PATIENT_ID")
	private Long patientId;       
	
	@Column(name="FACILITY_INFO_ID")
	private Long facilityInfoId; 
	
	@Column(name="PHR_FACILITY_CONTROL_ID")
	private Long phrFacilityControlId;    
	
	@Column(name="LOCATION")
	private String location;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getCurrentStatus() {
		return currentStatus;
	}

	public void setCurrentStatus(String currentStatus) {
		this.currentStatus = currentStatus;
	}

	public String getClinicName() {
		return clinicName;
	}

	public void setClinicName(String clinicName) {
		this.clinicName = clinicName;
	}

	public String getAppointmentStatus() {
		return appointmentStatus;
	}

	public void setAppointmentStatus(String appointmentStatus) {
		this.appointmentStatus = appointmentStatus;
	}

	public String getClinicPhone() {
		return clinicPhone;
	}

	public void setClinicPhone(String clinicPhone) {
		this.clinicPhone = clinicPhone;
	}

	public String getAppointmentType() {
		return appointmentType;
	}

	public void setAppointmentType(String appointmentType) {
		this.appointmentType = appointmentType;
	}

	public Date getXrayDatePrecise() {
		return xrayDatePrecise;
	}

	public void setXrayDatePrecise(Date xrayDatePrecise) {
		this.xrayDatePrecise = xrayDatePrecise;
	}

	public String getXrayDateImprecise() {
		return xrayDateImprecise;
	}

	public void setXrayDateImprecise(String xrayDateImprecise) {
		this.xrayDateImprecise = xrayDateImprecise;
	}

	public Date getLabDatePrecise() {
		return labDatePrecise;
	}

	public void setLabDatePrecise(Date labDatePrecise) {
		this.labDatePrecise = labDatePrecise;
	}

	public String getLabDateImprecise() {
		return labDateImprecise;
	}

	public void setLabDateImprecise(String labDateImprecise) {
		this.labDateImprecise = labDateImprecise;
	}

	public Date getApptDatePrecise() {
		return apptDatePrecise;
	}

	public void setApptDatePrecise(Date apptDatePrecise) {
		this.apptDatePrecise = apptDatePrecise;
	}

	public String getApptDateImprecise() {
		return apptDateImprecise;
	}

	public void setApptDateImprecise(String apptDateImprecise) {
		this.apptDateImprecise = apptDateImprecise;
	}

	public Date getEkgDatePrecise() {
		return ekgDatePrecise;
	}

	public void setEkgDatePrecise(Date ekgDatePrecise) {
		this.ekgDatePrecise = ekgDatePrecise;
	}

	public String getEkgDateImprecise() {
		return ekgDateImprecise;
	}

	public void setEkgDateImprecise(String ekgDateImprecise) {
		this.ekgDateImprecise = ekgDateImprecise;
	}

	public String getIen() {
		return ien;
	}

	public void setIen(String ien) {
		this.ien = ien;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Long getFacilityInfoId() {
		return facilityInfoId;
	}

	public void setFacilityInfoId(Long facilityInfoId) {
		this.facilityInfoId = facilityInfoId;
	}

	public Long getPhrFacilityControlId() {
		return phrFacilityControlId;
	}

	public void setPhrFacilityControlId(Long phrFacilityControlId) {
		this.phrFacilityControlId = phrFacilityControlId;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}     

}
